IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_IMP_EST_PROD_COND_CP_PG_FORN]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_IMP_EST_PROD_COND_CP_PG_FORN]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO
 
--EXEC P_IMP_EST_PROD_COND_CP_PG_FORN 1,3433422402683,0,92,155.69,0.00,'2016-11-21','2016-11-21'
CREATE PROCEDURE [dbo].[P_IMP_EST_PROD_COND_CP_PG_FORN] (@CD_EMP INT,
												   @CD_PROD_FORN VARCHAR(20),
												   @TP_COD INT,
												   @CD_FORN INT,												   
												   @VLR_TABELA MONEY, 
												   @PERC_DESC INT,
												   @DT_INI DATE,
												   @DT_FIM DATE,
												   @QT_EST MONEY = 0)
												   
 --TP_COD:
-- 0 - CODIGO DE BARRAS
-- 1 - CD_PROD_FORN												   
												   
WITH ENCRYPTION AS
SET NOCOUNT ON;
BEGIN
	DECLARE @CD_PROD INT
	DECLARE @APRES_QT_CP MONEY

	--IDENTIFICANDO PRODUTO	
	IF @TP_COD=0 --CÓDIGO DE BARRAS 
	BEGIN
		SET @CD_PROD=ISNULL((SELECT CD_PROD  FROM EST_PROD_CD_BARRA WHERE CD_EMP=@CD_EMP AND CD_BARRA= @CD_PROD_FORN),0);
	END
	ELSE --CODIGO INTERNO FORNECEDOR
	BEGIN
		SET @CD_PROD=ISNULL((SELECT CD_PROD FROM EST_PROD_FORN WHERE CD_EMP=@CD_EMP AND CD_FORN=@CD_FORN AND CD_PROD_FORN=@CD_PROD_FORN),0);
	END

	SET @APRES_QT_CP=0

	IF @CD_PROD=0
	BEGIN
		RETURN;
	end


	--DEFININDO EMBALAGEM DE COMPRA
	SELECT 
		@APRES_QT_CP= ISNULL((ISNULL(APRES_EMB_CP,1) * ISNULL(APRES_QT_CP,1)),0)
	FROM
		EST_PROD_FORN
	WHERE
		CD_EMP=@CD_EMP
		AND CD_FORN=@CD_FORN
		AND CD_PROD=@CD_PROD
		AND APRES_EMB_CP IS NOT NULL
		AND APRES_QT_CP>=1
				
	IF @APRES_QT_CP=0
	BEGIN
		SELECT
			@APRES_QT_CP=ISNULL((ISNULL(APRES_EMB_CP,1)* ISNULL(APRES_QT_CP,1)),0)
		FROM
			EST_PROD
		WHERE
			CD_EMP=@CD_EMP
			AND CD_PROD=@CD_PROD			
	END 

	IF @APRES_QT_CP=0
		BEGIN
			SET @APRES_QT_CP=1
		END 

	--DEFININDO PREÇO DE CUSTO
	SET @VLR_TABELA=(@VLR_TABELA / @APRES_QT_CP)


	--REMOVENDO VINCULO CONDIÇÃO COMERCIAL FORNECEDOR
	DELETE FROM
		EST_PROD_COND_CP_PG_FORN 
	WHERE 
		CD_EMP=@CD_EMP 
		AND CD_FORN=@CD_FORN
		AND CD_PROD=@CD_PROD
		AND ISNULL(TP_COND_CP,0)=0;

	--INSERINDO MELHOR CONDIÇÃO COMERCIAL FORNECEDOR
	INSERT INTO EST_PROD_COND_CP_PG_FORN (CD_EMP, CD_PROD, CD_FORN, CD_ORDEM, 
									VLR_CUSTO, PERC_DESC, ST_COND_CP, 
									DT_INI_VLD, DT_FIM_VLD,TP_COND_CP, QT_EST)												  
	SELECT
			@CD_EMP
			,@CD_PROD
			,@CD_FORN
			,99
			,@VLR_TABELA
			,@PERC_DESC
			,1
			,@DT_INI
			,@DT_FIM				
			,0
			,@QT_EST
	END



